#ifndef MYWINDOW1_MEMBER_FUNCTION_H_INCLUDED
#define MYWINDOW1_MEMBER_FUNCTION_H_INCLUDED

#include<gtkmm.h>
#include "functions.h"
#include "member.h"
#include "search.h"
b_mem_search::b_mem_search(){
    set_position(Gtk::WIN_POS_CENTER);
    set_default_size(300, 100);
    set_title("BOOK SEARCH");

    Gtk::Box *vbox = Gtk::manage(new Gtk::Box(Gtk::ORIENTATION_VERTICAL, 0));
    add(*vbox);

    Gtk::Grid *grid = Gtk::manage(new Gtk::Grid);
    grid->set_border_width(10);
    grid->set_row_spacing(5);
    grid->set_column_spacing(10);
    vbox->add(*grid);

    Gtk::Label *lbl1 = Gtk::manage(new Gtk::Label("ENTER BOOK NAME"));
    grid->attach(*lbl1, 0, 0, 1, 1);

    Gtk::Label *lbl2 = Gtk::manage(new Gtk::Label(""));
    grid->attach(*lbl2, 0, 1, 1, 1);

    Gtk::Entry *txtfld1 = Gtk::manage(new Gtk::Entry());
    grid->attach(*txtfld1, 1, 0, 2, 1);

    Gtk::Entry *txtfld2 = Gtk::manage(new Gtk::Entry());

    Gtk::Button *blogin = Gtk::manage(new Gtk::Button("SEARCH"));
    blogin->signal_clicked().connect(sigc::bind<Gtk::Entry*, Gtk::Entry*>(sigc::mem_fun(*this, &b_mem_search::on_button_click), txtfld1,txtfld2));
    grid->attach(*blogin, 2, 3, 1, 1);

    vbox->show_all();
};
b_mem_search::~b_mem_search(){

};

void b_mem_search::on_button_click(Gtk::Entry *txtfld1, Gtk::Entry *txtfld2){
    set_position(Gtk::WIN_POS_CENTER);
    char b_name[30];
    copy_ustring(b_name,txtfld1->get_text());
    if(book_search(b_name)){
        bsearch *popup=new bsearch;
        popup->popup= new SEARCH(b_name);
        popup->popup->show();
        hide();
    }
    else{
        Gtk::MessageDialog dlg("Book not found", false, Gtk::MESSAGE_ERROR, Gtk::BUTTONS_OK, true);
        dlg.set_title("ERROR");
        dlg.run();
    }
}

i_book::i_book(){
    set_position(Gtk::WIN_POS_CENTER);
    set_default_size(300, 100);
    set_title("BOOK ISSUE");

    Gtk::Box *vbox = Gtk::manage(new Gtk::Box(Gtk::ORIENTATION_VERTICAL, 0));
    add(*vbox);

    Gtk::Grid *grid = Gtk::manage(new Gtk::Grid);
    grid->set_border_width(10);
    grid->set_row_spacing(5);
    grid->set_column_spacing(10);
    vbox->add(*grid);

    Gtk::Label *lbl1 = Gtk::manage(new Gtk::Label("ENTER BOOK ID"));
    grid->attach(*lbl1, 0, 0, 1, 1);

    Gtk::Label *lbl2 = Gtk::manage(new Gtk::Label(""));
    grid->attach(*lbl2, 0, 1, 1, 1);

    Gtk::Entry *txtfld1 = Gtk::manage(new Gtk::Entry());
    grid->attach(*txtfld1, 1, 0, 2, 1);

    Gtk::Entry *txtfld2 = Gtk::manage(new Gtk::Entry());


    Gtk::Button *blogin = Gtk::manage(new Gtk::Button("ISSUE"));
    blogin->signal_clicked().connect(sigc::bind<Gtk::Entry*, Gtk::Entry*>(sigc::mem_fun(*this, &i_book::on_button_click), txtfld1,txtfld2));
    grid->attach(*blogin, 2, 3, 1, 1);

    vbox->show_all();
};
i_book::~i_book(){

};
void i_book::on_button_click(Gtk::Entry *txtfld1, Gtk::Entry *txtfld2){
    char b_id[30],m_id[30];
    copy_ustring(b_id,txtfld1->get_text());
    FILE *fbook;
    fbook=fopen("BOOK.txt","r");
    FILE *flin;
    flin=fopen("MEM_LOGIN.txt","r");
    fscanf(flin,"%s",m_id);
    fclose(flin);
    if(search_bid(b_id,fbook)){
        if(check_book(b_id)){
            if(check_member(m_id,b_id)){
                issue_book(b_id);
                dialog("Issued!!");
                hide();
            }
            else{
                Gtk::MessageDialog dlg("Can't Issue more books", false, Gtk::MESSAGE_ERROR, Gtk::BUTTONS_OK, true);
                dlg.set_title("ERROR");
                dlg.run();}
        }
        else{
            Gtk::MessageDialog dlg("Book already issued", false, Gtk::MESSAGE_ERROR, Gtk::BUTTONS_OK, true);
            dlg.set_title("ERROR");
            dlg.run();}
    }
    else{
        Gtk::MessageDialog dlg("Book not found", false, Gtk::MESSAGE_ERROR, Gtk::BUTTONS_OK, true);
        dlg.set_title("ERROR");
        dlg.run();
    }
}

r_mem_book::r_mem_book(){
    set_position(Gtk::WIN_POS_CENTER);
    set_default_size(300, 100);
    set_title("RETURN A BOOK");

    Gtk::Box *vbox = Gtk::manage(new Gtk::Box(Gtk::ORIENTATION_VERTICAL, 0));
    add(*vbox);

    Gtk::Grid *grid = Gtk::manage(new Gtk::Grid);
    grid->set_border_width(10);
    grid->set_row_spacing(5);
    grid->set_column_spacing(10);
    vbox->add(*grid);

    Gtk::Label *lbl1 = Gtk::manage(new Gtk::Label("ENTER BOOK ID"));
    grid->attach(*lbl1, 0, 0, 1, 1);

    Gtk::Label *lbl2 = Gtk::manage(new Gtk::Label(""));
    grid->attach(*lbl2, 0, 1, 1, 1);

    Gtk::Entry *txtfld1 = Gtk::manage(new Gtk::Entry());
    grid->attach(*txtfld1, 1, 0, 2, 1);

    Gtk::Entry *txtfld2 = Gtk::manage(new Gtk::Entry());


    Gtk::Button *blogin = Gtk::manage(new Gtk::Button("RETURN"));
    blogin->signal_clicked().connect(sigc::bind<Gtk::Entry*, Gtk::Entry*>(sigc::mem_fun(*this, &r_mem_book::on_button_click), txtfld1,txtfld2));
    grid->attach(*blogin, 2, 3, 1, 1);

    vbox->show_all();
};
r_mem_book::~r_mem_book(){

};
void r_mem_book::on_button_click(Gtk::Entry *txtfld1, Gtk::Entry *txtfld2){
    char b_id[30],m_id[30];
    copy_ustring(b_id,txtfld1->get_text());
    FILE *fbook;
    fbook=fopen("BOOK.txt","r");
    FILE *flin;
    flin=fopen("MEM_LOGIN.txt","r");
    fscanf(flin,"%s",m_id);
    fclose(flin);
    if(search_bid(b_id,fbook)){
        if(!check_book(b_id)){
            if(check_member_return(m_id,b_id)){
                return_book(b_id);
                dialog("Return Success!!");
                hide();
            }
            else{
                Gtk::MessageDialog dlg("You have not issued this book", false, Gtk::MESSAGE_ERROR, Gtk::BUTTONS_OK, true);
                dlg.set_title("ERROR");
                dlg.run();}
        }
        else{
            Gtk::MessageDialog dlg("Book is available", false, Gtk::MESSAGE_ERROR, Gtk::BUTTONS_OK, true);
            dlg.set_title("ERROR");
            dlg.run();}
    }
    else{
        Gtk::MessageDialog dlg("Book not found", false, Gtk::MESSAGE_ERROR, Gtk::BUTTONS_OK, true);
        dlg.set_title("ERROR");
        dlg.run();
    }

}

rq_book::rq_book(){
    set_position(Gtk::WIN_POS_CENTER);
    set_default_size(300, 100);
    set_title("REQUEST A BOOK");

    Gtk::Box *vbox = Gtk::manage(new Gtk::Box(Gtk::ORIENTATION_VERTICAL, 0));
    add(*vbox);

    Gtk::Grid *grid = Gtk::manage(new Gtk::Grid);
    grid->set_border_width(10);
    grid->set_row_spacing(5);
    grid->set_column_spacing(10);
    vbox->add(*grid);

    Gtk::Label *lbl1 = Gtk::manage(new Gtk::Label("ENTER BOOK NAME"));
    grid->attach(*lbl1, 0, 0, 1, 1);

    Gtk::Label *lbl2 = Gtk::manage(new Gtk::Label("ENTER AUTHOR NAME"));
    grid->attach(*lbl2, 0, 1, 1, 1);

    Gtk::Entry *txtfld1 = Gtk::manage(new Gtk::Entry());
    grid->attach(*txtfld1, 1, 0, 2, 1);

    Gtk::Entry *txtfld2 = Gtk::manage(new Gtk::Entry());
    grid->attach(*txtfld2, 1, 1, 2, 1);

    Gtk::Button *blogin = Gtk::manage(new Gtk::Button("REQUEST"));
    blogin->signal_clicked().connect(sigc::bind<Gtk::Entry*, Gtk::Entry*>(sigc::mem_fun(*this, &rq_book::on_button_click), txtfld1,txtfld2));
    grid->attach(*blogin, 2, 3, 1, 1);

    vbox->show_all();
};
rq_book::~rq_book(){

};
void rq_book::on_button_click(Gtk::Entry *txtfld1, Gtk::Entry *txtfld2){
    char m_id[30];
    get_curr_mem(m_id);
    cout<<m_id<<endl;

        if(!check_mem_rq(m_id)){

        char b_name[30],a_name[30];
        copy_ustring(b_name,txtfld1->get_text());
        copy_ustring(a_name,txtfld2->get_text());
        mem_book_request(m_id,b_name,a_name);
        Gtk::MessageDialog dlg("Success", false, Gtk::MESSAGE_INFO, Gtk::BUTTONS_OK, true);
        dlg.set_title("Success");
        dlg.run();
        hide();
    }
    else{
        Gtk::MessageDialog dlg("You have already requested a book", false, Gtk::MESSAGE_ERROR, Gtk::BUTTONS_OK, true);
        dlg.set_title("ERROR");
        dlg.run();
    }
}


c_mem_pwd::c_mem_pwd(){
    set_position(Gtk::WIN_POS_CENTER);
    set_default_size(300, 100);
    set_title("CHANGE PASSWORD");

    Gtk::Box *vbox = Gtk::manage(new Gtk::Box(Gtk::ORIENTATION_VERTICAL, 0));
    add(*vbox);

    Gtk::Grid *grid = Gtk::manage(new Gtk::Grid);
    grid->set_border_width(10);
    grid->set_row_spacing(5);
    grid->set_column_spacing(10);
    vbox->add(*grid);

    Gtk::Label *lbl1 = Gtk::manage(new Gtk::Label("ENTER OLD PASSWORD"));
    grid->attach(*lbl1, 0, 0, 1, 1);

    Gtk::Label *lbl2 = Gtk::manage(new Gtk::Label("ENTER NEW PASSWORD"));
    grid->attach(*lbl2, 0, 1, 1, 1);

    Gtk::Entry *txtfld1 = Gtk::manage(new Gtk::Entry());
    txtfld1->set_visibility(false);
    grid->attach(*txtfld1, 1, 0, 2, 1);

    Gtk::Entry *txtfld2 = Gtk::manage(new Gtk::Entry());
    txtfld2->set_visibility(false);
    grid->attach(*txtfld2, 1, 1, 2, 1);

    Gtk::Button *blogin = Gtk::manage(new Gtk::Button("CHANGE"));
    blogin->signal_clicked().connect(sigc::bind<Gtk::Entry*, Gtk::Entry*>(sigc::mem_fun(*this, &c_mem_pwd::on_button_click), txtfld1,txtfld2));
    grid->attach(*blogin, 2, 3, 1, 1);

    vbox->show_all();
};
c_mem_pwd::~c_mem_pwd(){

};

void c_mem_pwd::on_button_click(Gtk::Entry *txtfld1, Gtk::Entry *txtfld2){
    char m_id[30];
    FILE *flin;
    flin=fopen("MEM_LOGIN.txt","r");
    fscanf(flin,"%s",m_id);
    fclose(flin);
    char m_pwd_old[30],m_pwd_new[30];
    copy_ustring(m_pwd_old,txtfld1->get_text());
    copy_ustring(m_pwd_new,txtfld2->get_text());
    if(changpwd(m_id,m_pwd_old,m_pwd_new)){
        Gtk::MessageDialog dlg("SUCCESS!!", false, Gtk::MESSAGE_INFO, Gtk::BUTTONS_OK, true);
        dlg.set_title("ERROR");
        dlg.run();
        hide();
    }
    else{
        Gtk::MessageDialog dlg("Old password is not correct", false, Gtk::MESSAGE_ERROR, Gtk::BUTTONS_OK, true);
        dlg.set_title("ERROR");
        dlg.run();
    }
}

v_mem_det::v_mem_det(){
    set_position(Gtk::WIN_POS_CENTER);
    set_default_size(300, 200);
    set_title("YOUR DETAILS");
    char m_id[30],m_name[30],m_pwd[30],m_status[30];
    FILE *flin;
    flin=fopen("MEM_LOGIN.txt","r");
    fscanf(flin,"%s",m_id);
    fclose(flin);
    get_mem(m_id,m_name,m_pwd,m_status);
    string id,name,status;

    Gtk::Box *vbox = Gtk::manage(new Gtk::Box(Gtk::ORIENTATION_VERTICAL, 0));
    add(*vbox);

    Gtk::Grid *grid = Gtk::manage(new Gtk::Grid);
    grid->set_border_width(10);
    grid->set_row_spacing(5);
    grid->set_column_spacing(10);
    vbox->add(*grid);

    Gtk::Label *bf1 = Gtk::manage(new Gtk::Label(""));
    bf1->set_hexpand(true);
    grid->attach(*bf1, 0, 1, 1, 1);

    Gtk::Label *head = Gtk::manage(new Gtk::Label("YOUR DETAILS"));
    grid->attach(*head, 1, 0, 1, 1);

    Gtk::Label *lbl1 = Gtk::manage(new Gtk::Label("MEMBER ID :"));
    grid->attach(*lbl1, 0, 3, 1, 1);
    Gtk::Label *lbl2 = Gtk::manage(new Gtk::Label("NAME :"));
    grid->attach(*lbl2, 0, 4, 1, 1);
    Gtk::Label *lbl3 = Gtk::manage(new Gtk::Label("BOOK ISSUED :"));
    grid->attach(*lbl3, 0, 5, 1, 1);

    Gtk::Label *lbl4 = Gtk::manage(new Gtk::Label(m_id));
    grid->attach(*lbl4, 2, 3, 1, 1);
    Gtk::Label *lbl5 = Gtk::manage(new Gtk::Label(m_name));
    grid->attach(*lbl5, 2, 4, 1, 1);
    if(strcmp(m_status,"0")==0){
        Gtk::Label *lbl6 = Gtk::manage(new Gtk::Label("None"));
        grid->attach(*lbl6, 2, 5, 1, 1);
    }
    else{
        char b_id[30],b_name[30],a_name[30],b_status[30];
        find_book_issued(m_id,b_id);
        get(b_id,b_name,a_name,b_status);
        Gtk::Label *lbl6 = Gtk::manage(new Gtk::Label(b_id));
        grid->attach(*lbl6, 2, 5, 1, 1);
    }


    vbox->show_all();
};
v_mem_det::~v_mem_det(){

};

v_mem_rar::v_mem_rar(){
    set_position(Gtk::WIN_POS_CENTER);
    set_default_size(500, 200);
    set_title("RULES AND REGULATIONS");

    //VIRTUAL BOX

    Gtk::Box *vbox = Gtk::manage(new Gtk::Box(Gtk::ORIENTATION_VERTICAL, 0));
    add(*vbox);

    //ADDING A GRID TO THE VBOX

    Gtk::Grid *grid = Gtk::manage(new Gtk::Grid);
    grid->set_border_width(10);
    grid->set_row_spacing(5);
    grid->set_column_spacing(10);
    vbox->add(*grid);

    //A LABEL AT THE TOP

    Gtk::Label *heading1 = Gtk::manage(new Gtk::Label(""));
    heading1->set_hexpand(true);
    grid->attach(*heading1, 0, 0, 1, 1);

     Gtk::Label *heading2 = Gtk::manage(new Gtk::Label("RULES AND REGULATIONS"));
    heading2->set_hexpand(true);
    grid->attach(*heading2, 1, 0, 1, 1);

     Gtk::Label *heading3 = Gtk::manage(new Gtk::Label(""));
    heading3->set_hexpand(true);
    grid->attach(*heading3, 2, 0, 1, 1);

    Gtk::Label *heading4 = Gtk::manage(new Gtk::Label("1. Members can isue only one book at a time\n2. The books should be handled carefully. Any mishandling if spotted will directly cause loss of membership and fine.\n3. The users must bring a valid ID card and the user should never forget user ID and Pasword.\n4. Under no circumstances should any book be taken out of the library without checking it out.\n     However in case of any problem the user should approach the admin for any action to be taken.\n5. Guest users are not allowed to check out any book. However they are welcome to read in the library.\n6.Checking out and Deposition of books will be handled by the librarian and the administrator will address customer issues and feedbacks."));
    heading4->set_hexpand(true);
    grid->attach(*heading4, 1, 2, 1, 1);

    vbox->show_all();
};
v_mem_rar::~v_mem_rar(){

};

#endif // MYWINDOW1_MEMBER_FUNCTION_H_INCLUDED
